<?php 
/**
 * Video Popup shorcode
 */
namespace Elementor;

class esio_show_video_popup_widget extends Widget_Base {

    public function get_name() {
        return 'video-popup';
    }

    public function get_title() {
        return 'Esio - Video Popup';
    }

    public function get_icon() {
        return 'fab fa-elementor';
    }

    public function get_categories() {
        return [ 'esio-widgets' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
          'section_title',
            [
              'label' => __( 'Content', 'modeltheme' ),
            ]
          );

        $this->add_control(
          'button-text',
            [
              'label' => __( 'Button text', 'modeltheme' ),
              'label_block' => true,
              'type' => Controls_Manager::TEXT,
            ]
          );

        $this->add_control(
          'video-url',
            [
              'label' => __( 'Video URL', 'modeltheme' ),
              'label_block' => true,
              'type' => Controls_Manager::TEXT,
            ]
          );

        $this->end_controls_section();
    }

    protected function render() {

    global $ibid_redux;
    $settings     = $this->get_settings_for_display();
    $button_text     = $settings['button-text'];
    $video_url     = $settings['video-url'];

    $html = '';    

    $html .= '<a href="#MT-Video-Modal" class="Mt-modal_video_button" data-toggle="modal"><i class="fas fa-play"></i>'.esc_html__($button_text).'</a>
    <div id="MT-Video-Modal" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                  <div class="embed-responsive embed-responsive-16by9">
                    <iframe id="Video" class="embed-responsive-item" src="'.esc_url($video_url).'" allowfullscreen></iframe>
                  </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        jQuery(document).ready(function(){
            /* Get iframe src attribute value i.e. YouTube video url
            and store it in a variable */
            
            /* Assign empty url value to the iframe src attribute when
            modal hide, which stop the video playing */
            jQuery("#MT-Video-Modal").on("hide.bs.modal", function(){
                jQuery("#Video").attr("src", " ");
            });
            
            /* Assign the initially stored url back to the iframe src
            attribute when modal is displayed again */
            jQuery("#MT-Video-Modal").on("show.bs.modal", function(){
                jQuery("#Video").attr("src", "'.esc_url($video_url).'");
            });
        });
    </script>';
        echo $html;
    }
    protected function _content_template() {
    }
}
