<?php
namespace Elementor;

class esio_show_testimonials_slider_widget extends Widget_Base {

  public function get_name() {
    return 'testimonals-slider';
  }

  public function get_title() {
    return 'Esio - Testimonials';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
    );

    $this->add_control(
      'text_color',
        [
          'label' => __( 'Text color', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::COLOR,
          'default' => '#ffffff',
          'description' => __( 'Pick the color for the text', 'modeltheme' ),
        ]
    );

    $this->end_controls_section();
  }

  protected function render() {
    
    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $number           = $settings['number'];
    $text_color       = $settings['text_color'];

    $html = '';
    $html .= '<div class="testimonial-slider">';
      $html .= '<div class="testimonials-container owl-carousel owl-theme" id="sync1" >';
        $args_testimonials = array(
          'posts_per_page'   => $number,
          'orderby'          => 'post_date',
          'order'            => 'DESC',
          'post_type'        => 'testimonial',
          'post_status'      => 'publish' 
          ); 
        $testimonials = get_posts($args_testimonials);
        foreach ($testimonials as $testimonial) {
          $testimonial_id = $testimonial->ID;
          $content_post   = get_post($testimonial_id);
          $content        = $content_post->post_content;
          $content        = apply_filters('the_content', $content);
          $content        = str_replace(']]>', ']]&gt;', $content);

          #metaboxes
          $metabox_job_position = get_post_meta( $testimonial->ID, 'job-position', true );
          $metabox_company = get_post_meta( $testimonial->ID, 'company', true );
          $testimonial_id = $testimonial->ID;
          #thumbnail
          $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $testimonial->ID ),'connection_testimonials_150x150' );

          $html.='
        	<div class="wow item relative">
          	<div class="testimonial_item">        	
              <div class="testimonail-content">
                <p style="color:'.$text_color.';">"'.strip_tags($content).'"</p>
              </div>
            </div>
            <div class="testimonial_item_mobile">';
              $cls = '';
              if(!empty($thumbnail_src)) {
                $html.='<div class="testimonail-profile-img">';                        
                  $html.='<img alt="testimonial-image" src="'.$thumbnail_src[0].'">';
                $html.='</div>';
              } else {
                $cls .= 'text-center';                           
              }
              $html.='<div class="testimonail-name-position '.$cls.'">
                <h4 class="name-test" style="color:'.$text_color.';">'. $testimonial->post_title .'</h4>
                <p class="position-test" style="color:'.$text_color.';">'. $metabox_job_position .'</p>
              </div>';
            $html.='</div>
          </div>';
        }
      $html .= '</div>
    </div>';
    $html .= '<div class="mt_slider">';
    $html .= '<div class="testimonial-nav">';
      $html .= '<div class="testimonials-container owl-carousel owl-theme" id="sync2">';
        $testimonials_2 = get_posts($args_testimonials);
        foreach ($testimonials_2 as $testimonial) {
          #metaboxes
          $metabox_job_position = get_post_meta( $testimonial->ID, 'job-position', true );
          $metabox_company = get_post_meta( $testimonial->ID, 'company', true );
          $testimonial_id = $testimonial->ID;
          #thumbnail
          $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $testimonial->ID ),'connection_testimonials_150x150' );
          
          $html.='
          <div class="wow item relative">
            <div class="testimonial_item">';
                $cls = '';
                if(!empty($thumbnail_src)) {
                  $html.='<div class="testimonail-profile-img">';                        
                    $html.='<img alt="testimonial-image" src="'.$thumbnail_src[0].'">';
                  $html.='</div>';
                } else {
                  $cls .= 'text-center';                           
                }
                $html.='<div class="testimonail-name-position '.$cls.'">
                  <h4 class="name-test" style="color:'.$text_color.';">'. $testimonial->post_title .'</h4>
                  <p class="position-test" style="color:'.$text_color.';">'. $metabox_job_position .'</p>
                </div>';
              $html.='</div>
          </div>';
        }
      $html .= '</div>
    </div>
    </div>';
    echo $html;
  }
protected function _content_template() {

  }
}