<?php
namespace Elementor;

class esio_show_testimonials03_slider_widget extends Widget_Base {
  public function get_name() {
    return 'testimonals03-slider';
  }

  public function get_title() {
    return 'Esio - Testimonials 03 Slider';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
    );

    $this->add_control(
      'visible_items',
      [
        'label' => __( 'Visible items', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
          '1' => __( '1 item', 'modeltheme' ),
          '2' => __( '2 items', 'modeltheme' ),
          '3' => __( '3 items', 'modeltheme' ),
        ]
      ]
    );

    $this->end_controls_section();
  }

  protected function render() {

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $number           = $settings['number'];
    $visible_items    = $settings['visible_items'];

    $html = '';
    $html .= '<div class="vc_row">';
        $html .= '<div class="testimonials-'.$visible_items.'">';
        $args_testimonials = array(
                'posts_per_page'   => $number,
                'orderby'          => 'post_date',
                'order'            => 'DESC',
                'post_type'        => 'testimonial',
                'post_status'      => 'publish' 
                ); 
        $testimonials = get_posts($args_testimonials);
            foreach ($testimonials as $testimonial) {
                #metaboxes
                $metabox_content_color = get_post_meta( $testimonial->ID, 'testimonial_color', true );
                $metabox_job_position = get_post_meta( $testimonial->ID, 'job-position', true );
                $metabox_company = get_post_meta( $testimonial->ID, 'company', true );
                $testimonial_id = $testimonial->ID;
                $content_post   = get_post($testimonial_id);
                $content        = $content_post->post_content;
                $content        = apply_filters('the_content', $content);
                $content        = str_replace(']]>', ']]&gt;', $content);
                #thumbnail
                $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $testimonial->ID ),'connection_testimonials_150x150' );
                
                $html.='
                  <div class="wow vc_col-md-4 relative">
                    <div class="testimonial01_item">          
                      <div class="testimonial01-img-holder pull-left">
                        <div class="testimonail01-content" style="color:'.$metabox_content_color.';"><p>'.strip_tags(modeltheme_excerpt_limit($content,60)).'</p></div>
                        <div class="testimonail01-profile-content">';
                          
                          $cls = '';
                          if(!empty($thumbnail_src)) {

                            $html.='<div class="testimonail01-profile-img">';                        
                               $html.='<img alt="testimonial-image" src="'.$thumbnail_src[0].'">';
                            $html.='</div>';
                          } else {
                             $cls .= 'text-center';                           
                          }
                         
                          $html.='<div class="testimonail01-name-position '.$cls.'">
                            <h2 class="name-test" style="color:'.$metabox_content_color.';"><strong>'. $testimonial->post_title .'</strong></h2>
                            <p class="position-test" style="color:'.$metabox_content_color.';">'. $metabox_job_position .'</p>
                        </div>
                    </div>
                      </div>
                    </div>
                  </div>';
            }
    $html .= '</div>
      </div>';
    echo $html;
  }
  protected function _content_template() {

  }
}