<?php
namespace Elementor;

class esio_show_services_slider_widget extends Widget_Base {

  public function get_name() {
    return 'services-slider';
  }

  public function get_title() {
    return 'Esio - Services Slider';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '7',
        ]
    );

   $post_category_tax = get_terms('mt-service-category');
    $post_category = array();
    if ($post_category_tax) {
      foreach ( $post_category_tax as $term ) {
         $post_category[$term->slug] = $term->name;
      }
      $post_category['all_categories'] = 'All categories';
    }

    $this->add_control(
      'category',
      [
        'label' => __( 'Select Services Category', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => 'web',
        'options' => $post_category,
      ]
    );

    $this->add_control(
      'visible_items',
      [
        'label' => __( 'Visible items', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => '5',
        'options' => [
          '3' => __( '3 items', 'modeltheme' ),
          '4' => __( '4 items', 'modeltheme' ),
          '5' => __( '5 items', 'modeltheme' ),
        ]
      ]
    );

    $this->end_controls_section();
  }
  protected function render() {
    
    global $wpdb;
    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $category         = $settings['category'];
    $number           = $settings['number'];
    $visible_items    = $settings['visible_items'];

    $tax_query[ ] = array();
    if( $category != 'all_categories' ) {
      $tax_query  = array(
        array(
          'taxonomy' => 'mt-service-category',
          'field'    => 'slug',
          'terms'    => $category,
        )
      );
      $args = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'mt_service',
        'tax_query' => $tax_query,
        'post_status'      => 'publish' 
      ); 
    } elseif( $category == 'all_categories' ) {
      $args = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'mt_service',
        'post_status'      => 'publish' 
      ); 
    }

    $html = '';
        $html .= '<div class="modeltheme-services-slider-'.$visible_items.' modeltheme-services-slider">';
        
        $services = new \WP_Query($args);
        if( $services -> have_posts() ) {
          while( $services->have_posts() ){
            $services->the_post();
            $title = get_the_title();
            $permalink = get_the_permalink();
            $html.='
              <div class="item modeltheme-service"><h3 class="service_name"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                <div class="service-icon"><a href="'.get_the_permalink().'"><i class="fas fa-link"></i></a></div>
                <div class="services-shadow-overlay">
                </div>
              </div>';
          }
          wp_reset_query();
          $html .= '</div>';
        }
    
    echo $html;
  }
  protected function _content_template() {

  }
}
