<?php
namespace Elementor;

class esio_show_blog_post_widget extends Widget_Base {

  public function get_name() {
    return 'blog-posts';
  }

  public function get_title() {
    return 'Esio - Blog Posts';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {

    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
      );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
      );

      $post_category_tax = get_terms('category');
      $post_category = array();
      if ($post_category_tax) {
        foreach ( $post_category_tax as $term ) {
           $post_category[$term->slug] = $term->name;
        }
        $post_category['all_categories'] = 'All categories';
      }

      $this->add_control(
        'category',
        [
          'label' => __( 'Select Blog Category', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::SELECT,
          'default' => 'web',
          'options' => $post_category,
        ]
      );

      $this->add_control(
      'columns',
      [
        'label' => __( 'Columns', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => '2 columns',
        'options' => [
          'col-md-4' => __( '3 column', 'modeltheme' ),
          'col-md-6' => __( '2 columns', 'modeltheme' ),
        ]
      ]
    );

    $this->end_controls_section();
  }

  protected function render() {
    global $ibid_redux;
    $settings     = $this->get_settings_for_display();
    $category     = $settings['category'];
    $number     = $settings['number'];
    $columns    = $settings['columns'];
    
    $html = '';
    $html .= '<div class="blog-posts simple-posts blog-posts-shortcode wow">';
    $html .= '<div class="row">';

    $tax_query[ ] = array();
    if($category != 'all_categories') {
      $tax_query  = array(
        array(
          'taxonomy' => 'category',
          'field'    => 'slug',
          'terms'    => $category,
        )
      );
      $args_blogposts = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'post',
        'tax_query' => $tax_query,
        'post_status'      => 'publish' 
      ); 
    } elseif($category == 'all_categories') {
      $args_blogposts = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'post',
        'post_status'      => 'publish' 
      ); 
    }
    
   
    $blogposts = get_posts($args_blogposts);
    foreach ($blogposts as $blogpost) {
      #thumbnail
      if($columns == 'col-md-6') {
        $image_size = 'esio_listing_archive_featured_square';
      }
      elseif ($columns == 'col-md-4') {
        $image_size = 'esio_listing_archive_featured_square';
      }
      $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( $blogpost->ID ), $image_size );
      $content_post   = get_post($blogpost->ID);
      $content        = $content_post->post_content;
      $content        = apply_filters('the_content', $content);
      $content        = str_replace(']]>', ']]&gt;', $content);
      if ($thumbnail_src) {
        $post_img = '<img class="blog_post_image" src="'. esc_url($thumbnail_src[0]) . '" alt="'.$blogpost->post_title.'" />';
        $post_col = '';
      }else{
        $post_col = 'col-md-12 no-featured-image';
        $post_img = '';
      }
      $author_id = get_post_field ('post_author', $blogpost->ID);
      $display_name = get_the_author_meta( 'display_name' , $author_id ); 
      $html.='
      <div class="'.esc_attr($columns).'">
        <article class="single-post list-view">
          <div class="blog_custom">
            <!-- POST THUMBNAIL -->
            <div class="post-thumbnail">
              <a class="relative" href="'.get_permalink($blogpost->ID).'">
                <div class="featured_image_blog">'
                  .$post_img.
                '</div>
              </a>
            </div>
            <!-- POST DETAILS -->
            <div class="post-details '.$post_col.'">
              <h3 class="post-name row">
                <a href="'.get_permalink($blogpost->ID).'" title="'. $blogpost->post_title .'">'. $blogpost->post_title .'</a>
              </h3>
              <div class="post-excerpt row">
                <p>'.strip_tags(modeltheme_excerpt_limit($content, 8)).'...</p>
                
                <div class="blog-slider01-button">
                  <a href="'.get_the_permalink().'" class="read-more">'.esc_html__('Read More', 'modeltheme').'<i class="fa fa-arrow-right"></i></a>
                </div>

              </div>
            </div>                       
          </div>
        </article>
      </div>';
      }
    $html .= '</div>';
    $html .= '</div>';
    echo $html;
  }
  protected function _content_template() {

  }
}