<?php
namespace Elementor;

class esio_show_blog_post_slider_widget extends Widget_Base {

  public function get_name() {
    return 'blog-posts-slider';
  }

  public function get_title() {
    return 'Esio - Blog Posts Slider';
  }

  public function get_icon() {
    return 'fab fa-elementor';
  }

  public function get_categories() {
    return [ 'esio-widgets' ];
  }

  protected function _register_controls() {
    $this->start_controls_section(
      'section_title',
        [
          'label' => __( 'Content', 'modeltheme' ),
        ]
    );

    $this->add_control(
      'number',
        [
          'label' => __( 'Number', 'modeltheme' ),
          'label_block' => true,
          'type' => Controls_Manager::TEXT,
          'default' => '3',
        ]
    );

    $post_category_tax = get_terms('category');
    $post_category = array();
    if ($post_category_tax) {
      foreach ( $post_category_tax as $term ) {
         $post_category[$term->slug] = $term->name;
      }
      $post_category['all_categories'] = 'All categories';
    }

    $this->add_control(
      'category',
      [
        'label' => __( 'Select Blog Category', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => 'all_categories',
        'options' => $post_category,
      ]
    );

    $this->add_control(
      'visible_items',
      [
        'label' => __( 'Visible items', 'modeltheme' ),
        'label_block' => true,
        'type' => Controls_Manager::SELECT,
        'default' => '3',
        'options' => [
          '2' => __( '2 items', 'modeltheme' ),
          '3' => __( '3 items', 'modeltheme' ),
        ]
      ]
    );

    $this->end_controls_section();
  }
  protected function render() {
    global $wpdb;

    global $ibid_redux;
    $settings         = $this->get_settings_for_display();
    $category         = $settings['category'];
    $number           = $settings['number'];
    $visible_items    = $settings['visible_items'];

    $html = '';
    $html .= '<div class="mt_slider">';
      $html .= '<div class="blog-slider-container-'.$visible_items.' blog-slider-container owl-carousel owl-theme">';
    $tax_query[ ] = array();
    if( $category != 'all_categories' ) {
      $tax_query  = array(
        array(
          'taxonomy' => 'category',
          'field'    => 'slug',
          'terms'    => $category,
        )
      );
      $args = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'post',
        'tax_query' => $tax_query,
        'post_status'      => 'publish' 
      ); 
    } elseif( $category == 'all_categories' ) {
      $args = array(
        'posts_per_page'   => $number,
        'orderby'          => 'post_date',
        'order'            => 'DESC',
        'post_type'        => 'post',
        'post_status'      => 'publish' 
      ); 
    }

        $posts = new \Wp_Query($args);
        if ( $posts->have_posts() ) {
          while ( $posts->have_posts() ) {
            $posts->the_post();
            #author meta
            $deff_author_avatar_img_url = get_template_directory_uri().'img/author-img.png';
            $author_avatar = get_avatar( get_the_author_meta( 'ID' ), 50 );
            #post thumbnail
            $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'esio_portfolios_600x600' );
            $html.='
              <div class="wow item vc_col-md-12 relative">
                <div class="blog-slider01_item">';
                  $html.='<div class="blog-thumbnail-overlay">';
                    if ($thumbnail_src) {
                      $html.='<img src="'.esc_url($thumbnail_src[0]).'" alt="'.the_title_attribute('echo=0').'" />';
                    }
                  $html.='</div>';
                  $html.='<div class="blog-slider-author-info">
                    <div class="blog-slider01-img-holder">';
                      if(!empty($author_avatar)) {
                        $html.='<div class="blog-slider01-author-img">';                        
                          $html.=$author_avatar;
                        $html.='</div>';
                      } else {
                        $html.='<div class="blog-slider01-author-img">';                        
                          $html.='<img src="'.$deff_author_avatar_img_url.'" alt="author_avatar"/>';
                        $html.='</div>';
                      }
                    $html.='</div>
                    <div class="author-info">
                      <p class="author-name">'.esc_html__('Posted by ', 'modeltheme').'<strong>'.get_the_author().'</strong></p>
                      <p class="post_date">'.get_the_date().'</p>
                    </div>
                  </div>           


                  <div class="blog-slider01-title" >
                    <h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                  </div>
                  <div class="blog-slider01-button">
                    <a href="'.get_the_permalink().'" class="read-more">'.esc_html__('Read More', 'modeltheme').'<i class="fa fa-arrow-right"></i></a>
                    </div>
                </div>
              </div>';
          }
        }

  wp_reset_postdata();
    $html .= '</div>
      </div>';
    echo $html;
}
protected function _content_template() {

  }
}