<?php

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
 
// check for plugin using plugin name


class My_Elementor_Widgets {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		if ( is_plugin_active( 'modeltheme-knowledge/modeltheme-knowledge.php' ) ) {
			require_once('widgets/mt-portfolio-grid.php');
			require_once('widgets/mt-portfolio-single-info.php');
			require_once('widgets/mt-portfolio-categories.php');
			require_once('widgets/mt-portfolio-grid_v2.php');
			require_once('widgets/mt-portfolio-slider.php');
			require_once('widgets/mt-services-slider.php');
		}
		require_once('widgets/mt-blog-posts.php');
		require_once('widgets/mt-blog-post-slider.php');
		require_once('widgets/mt-mailchimp-subscribe-form.php');
		require_once('widgets/mt-testimonials01.php');
		require_once('widgets/mt-testimonials02.php');
		require_once('widgets/mt-testimonials03.php');
		require_once('widgets/mt-testimonials04.php');
		require_once('widgets/mt-typed-text.php');
		require_once('widgets/mt-video-popup.php');
		require_once('widgets/mt-countdown.php');
		require_once('widgets/mt-timeline.php');

		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		if ( is_plugin_active( 'modeltheme-knowledge/modeltheme-knowledge.php' ) ) {
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_portfolio_grid_widget() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_portfolio_grid02_widget() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_portfolio_slider_widget() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_services_slider_widget() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_portfolio_single_info_widget() );
			\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_portfolio_categories_widget() );
		}
		// \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_mailchimp_subscribe_form() );
		// \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_testimonials02_slider_widget() );
		// \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_testimonials03_slider_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_blog_post_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_blog_post_slider_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_testimonials01_slider_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_testimonials_slider_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_typed_text_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_countdown_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_video_popup_widget() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\esio_show_timeline_widget() );
	}

}

add_action( 'init', 'my_elementor_init' );
function my_elementor_init() {
	My_Elementor_Widgets::get_instance();
}

function add_elementor_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'esio-widgets',
		[
			'title' => __( 'esio', 'modeltheme' ),
			'icon' => 'fa fa-plug',
		]
	);

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );